/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import lotr.common.LOTRMod;
import lotr.common.item.LOTRItemCoin;
import lotr.common.util.LOTRNetwork;
import lotr.common.util.LOTRPacketMoneyChange;
import lotr.common.util.LOTRPlayerMoneyData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class LOTRPacketMoneyGet
implements LOTRNetwork.LOTRRPMessage {
    private ItemStack item;
    private static final int MILESTONE_AMOUNT = 500000;
    private static final String CONSOLE_MESSAGE = "\u001b[31mPlayer %s has reached %d coins!\u001b[0m";
    private static final String MESSAGE_PLAYER_REACHED = "lotr.gui.money.get";

    public LOTRPacketMoneyGet() {
    }

    public LOTRPacketMoneyGet(ItemStack items) {
        this.item = items;
    }

    @Override
    public IMessage process(MessageContext context) {
        LOTRMod.network.execute(Side.SERVER, () -> () -> {
            if (LOTRMod.sellitems.containsKey(this.item)) {
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                LOTRPlayerMoneyData data = LOTRPlayerMoneyData.of((EntityPlayer)player);
                int cost = LOTRMod.sellitems.get(this.item);
                int index = -1;
                for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    if (player.field_71071_by.field_70462_a[i] == null || player.field_71071_by.field_70462_a[i].func_77973_b() != this.item.func_77973_b() || player.field_71071_by.field_70462_a[i].func_77960_j() != this.item.func_77960_j()) continue;
                    index = i;
                    break;
                }
                if (index >= 0) {
                    if (--player.field_71071_by.field_70462_a[index].field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[index] = null;
                    }
                    int coinValue = this.getCoinValueFromDamage(this.item);
                    data.money += cost;
                    LOTRPacketMoneyChange packets = new LOTRPacketMoneyChange(data.money);
                    packets.sendTo(player);
                    String itemDisplayName = this.item.func_82833_r();
                    String message = StatCollector.func_74837_a((String)MESSAGE_PLAYER_REACHED, (Object[])new Object[]{coinValue, itemDisplayName});
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
                    player.field_70170_p.func_72956_a((Entity)player, "lotr:event.trade", 0.5f, 1.0f + (player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.1f);
                    int milestonesReached = data.money / 500000;
                    int lastMilestone = (data.money - cost) / 500000;
                    if (milestonesReached > lastMilestone) {
                        System.out.println(String.format(CONSOLE_MESSAGE, player.getDisplayName(), data.money));
                    }
                }
            }
        });
        return null;
    }

    private int getCoinValueFromDamage(ItemStack itemstack) {
        int damage;
        if (itemstack != null && itemstack.func_77973_b() instanceof LOTRItemCoin && (damage = itemstack.func_77960_j()) >= 0 && damage < LOTRItemCoin.values.length) {
            return LOTRItemCoin.values[damage];
        }
        return 0;
    }

    @Override
    public void readBuffer(PacketBuffer packet) {
        try {
            this.item = packet.func_150791_c();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeBuffer(PacketBuffer packet) {
        try {
            packet.func_150788_a(this.item);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

